<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-01-27 09:50
 */
interface QuickprofitgeneralDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Quickprofitgeneral 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param quickprofitgeneral primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Quickprofitgeneral quickprofitgeneral
 	 */
	public function insert($quickprofitgeneral);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Quickprofitgeneral quickprofitgeneral
 	 */
	public function update($quickprofitgeneral);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByNetSellVal($value);

	public function queryByNetSellCostBuyPrice($value);

	public function queryByNetSellCostLastBuyPrice($value);

	public function queryByNetSellCostMeanBuyPrice($value);

	public function queryByNetSellCostLastBuyPricewithDiscount($value);

	public function queryByNetSellCostMeanBuyPricewithDiscount($value);


	public function deleteByNetSellVal($value);

	public function deleteByNetSellCostBuyPrice($value);

	public function deleteByNetSellCostLastBuyPrice($value);

	public function deleteByNetSellCostMeanBuyPrice($value);

	public function deleteByNetSellCostLastBuyPricewithDiscount($value);

	public function deleteByNetSellCostMeanBuyPricewithDiscount($value);


}
?>